local addonName = ...

local MB_Lang = "en"

local function L(cs, en)
    if MB_Lang == "en" then
        return en
    else
        return cs
    end
end

local CS_FONT_PATH = "Interface\\AddOns\\MaterialBank\\Fonts\\FRIZQT.ttf"

-------------------------------------------------
-- Debug helper
-------------------------------------------------
local function Debug(msg)
    -- print("|cffff8800[MB Debug]|r " .. tostring(msg))
end

-------------------------------------------------
-- SavedVariables & SYNC cache
-------------------------------------------------
local cache
local syncTemp
local syncMoneyTemp

local MB_TableHidden = false
local MB_ToggleButton

local MB_EXPANDED_W, MB_EXPANDED_H = 340, 215

local MB_TOGGLE_W, MB_TOGGLE_H = 18, 15
local MB_TOGGLE_PAD_X, MB_TOGGLE_PAD_Y = 8, -6 

local MB_COLLAPSED_W = MB_TOGGLE_PAD_X + MB_TOGGLE_W
local MB_COLLAPSED_H = (-MB_TOGGLE_PAD_Y) + MB_TOGGLE_H

local MB_BackdropDef = {
    bgFile   = "Interface\\DialogFrame\\UI-DialogBox-Background",
    edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border",
    tile = true, tileSize = 16, edgeSize = 16,
    insets = { left = 3, right = 3, top = 3, bottom = 3 },
}

local UpdateInfoPanel

local function GetCharKey()
    local name = UnitName("player")
    local realm = GetRealmName() or "UnknownRealm"
    return name .. "-" .. realm
end

-------------------------------------------------
-- Chat filtr na SYNC spam
-------------------------------------------------
local function MaterialBank_SystemFilter(self, event, msg, ...)
    if msg:find("SYNC_LANG=", 1, true)
        or msg:find("SYNC_BEGIN", 1, true)
        or msg:find("SYNC_END", 1, true)
        or msg:find("SYNC item=", 1, true)
        or msg:find("SYNC money=", 1, true)
        or msg:find("MB_UPDATE", 1, true)
    then
        return true
    end
end

-------------------------------------------------
-- UI prvky: tlačítka, info okno, množství craftů
-------------------------------------------------
local MB_PullButton
local MB_SyncButton
local MB_InfoFrame
local MB_InfoLines = {}
local MB_CurrentMode

-- počítadlo craftů
local MB_CraftCount = 1
local MB_CraftMax   = 0

local MB_CountFrame
local MB_CountText
local MB_CountUp
local MB_CountDown

-------------------------------------------------
-- Frame & eventy
-------------------------------------------------
local frame = CreateFrame("Frame")
frame:RegisterEvent("ADDON_LOADED")
frame:RegisterEvent("TRADE_SKILL_SHOW")
frame:RegisterEvent("TRADE_SKILL_CLOSE")
frame:RegisterEvent("CRAFT_SHOW")
frame:RegisterEvent("CRAFT_CLOSE")
frame:RegisterEvent("CHAT_MSG_SYSTEM")

-------------------------------------------------
-- Helper pro malá „flat“ tlačítka v rámečku
-------------------------------------------------
local function CreateFlatButton(name, parent, text)
    local btn = CreateFrame("Button", name, parent)
    btn:SetSize(55, 15)

    -- zlatý rámeček okolo
    local border = btn:CreateTexture(nil, "BACKGROUND")
    border:SetTexture(1, 0.82, 0, 0.7)
    border:SetPoint("TOPLEFT", -1, 1)
    border:SetPoint("BOTTOMRIGHT", 1, -1)

    -- modré pozadí uvnitř rámečku
    local bg = btn:CreateTexture(nil, "BORDER")
    bg:SetTexture("Interface\\TargetingFrame\\UI-StatusBar")
    bg:SetVertexColor(0.1, 0.45, 0.9, 0.9)
    bg:SetPoint("TOPLEFT", 0, 0)
    bg:SetPoint("BOTTOMRIGHT", 0, 0)
    btn.bg = bg

    btn:SetNormalFontObject(GameFontHighlightSmall)
    btn:SetText(text)
    local fs = btn:GetFontString()
    fs:ClearAllPoints()
    fs:SetPoint("CENTER", btn, "CENTER", 0, 0)

    btn:SetHighlightTexture(nil)
    btn:SetPushedTexture(nil)

    btn:SetScript("OnEnter", function(self)
        if self:IsEnabled() then
            self.bg:SetVertexColor(0.2, 0.65, 1.0, 0.95)
        end
    end)
    btn:SetScript("OnLeave", function(self)
        if self:IsEnabled() then
            self.bg:SetVertexColor(0.1, 0.45, 0.9, 0.9)
        end
    end)

    return btn
end

-------------------------------------------------
-- Toggle tabulky (+ / -)
-------------------------------------------------
local function MB_UpdateToggleVisual()
    if not MB_ToggleButton then
        return
    end

    if MB_TableHidden then
        MB_ToggleButton:SetText("+")
    else
        MB_ToggleButton:SetText("-")
    end

    -- větší znak
    local fs = MB_ToggleButton:GetFontString()
    if fs then
        if MB_Lang == "cs" then
            fs:SetFont(CS_FONT_PATH, 18, "OUTLINE")
        else
            fs:SetFont(GameFontHighlight:GetFont(), 18, "OUTLINE")
        end
    end
end

local function MB_SetExpandedAnchor(parent)
    if not MB_InfoFrame or not parent then
        return
    end

    MB_InfoFrame:ClearAllPoints()
    MB_InfoFrame:SetPoint("LEFT", parent, "RIGHT", -35, -75)
    MB_InfoFrame._expandedParent = parent
end

local function MB_ApplyTableVisibility()
    if not MB_InfoFrame then
        return
    end

    local btnLeft, btnTop
    if MB_ToggleButton and MB_ToggleButton:IsShown() then
        btnLeft = MB_ToggleButton:GetLeft()
        btnTop  = MB_ToggleButton:GetTop()
    end

    if MB_TableHidden then
        MB_InfoFrame:SetSize(MB_COLLAPSED_W, MB_COLLAPSED_H)
        MB_InfoFrame:SetBackdrop(nil)

        if btnLeft and btnTop then
            local frameLeft = btnLeft - MB_TOGGLE_PAD_X
            local frameTop  = btnTop  - MB_TOGGLE_PAD_Y
            MB_InfoFrame:ClearAllPoints()
            MB_InfoFrame:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT", frameLeft, frameTop)
        end

        if MB_InfoFrame.title then MB_InfoFrame.title:Hide() end
        for _, line in ipairs(MB_InfoLines) do
            if line then line:Hide() end
        end
        if MB_SyncButton then MB_SyncButton:Hide() end
        if MB_PullButton then MB_PullButton:Hide() end
        if MB_CountFrame then MB_CountFrame:Hide() end

    else
        MB_SetExpandedAnchor(MB_InfoFrame._expandedParent or MB_InfoFrame:GetParent() or UIParent)

        MB_InfoFrame:SetSize(MB_EXPANDED_W, MB_EXPANDED_H)
        MB_InfoFrame:SetBackdrop(MB_BackdropDef)
        MB_InfoFrame:SetBackdropColor(0, 0, 0, 0.8)

        if MB_InfoFrame.title then MB_InfoFrame.title:Show() end
        for _, line in ipairs(MB_InfoLines) do
            if line then line:Show() end
        end

        if MB_SyncButton then MB_SyncButton:Show() end
    end

    MB_UpdateToggleVisual()
end

-------------------------------------------------
-- Přepínání fontů podle MB_Lang
-------------------------------------------------
local function ApplyLocalizationFonts()
    if not MB_InfoFrame then
        return
    end

    -- Title
    if MB_InfoFrame.title then
        if MB_Lang == "cs" then
            MB_InfoFrame.title:SetFont(CS_FONT_PATH, 12, "OUTLINE")
        else
            MB_InfoFrame.title:SetFontObject(GameFontHighlight)
        end
    end

    -- řádky v tabulce (name+info)
    for _, line in ipairs(MB_InfoLines) do
        if line then
            local nameFS = line.nameFS
            local infoFS = line.infoFS
            if nameFS then
                if MB_Lang == "cs" then
                    nameFS:SetFont(CS_FONT_PATH, 10, "")
                else
                    nameFS:SetFontObject(GameFontHighlightSmall)
                end
            end
            if infoFS then
                if MB_Lang == "cs" then
                    infoFS:SetFont(CS_FONT_PATH, 10, "")
                else
                    infoFS:SetFontObject(GameFontHighlightSmall)
                end
            end
        end
    end

    -- tlačítka (text na nich)
    if MB_PullButton and MB_PullButton:GetFontString() then
        if MB_Lang == "cs" then
            MB_PullButton:GetFontString():SetFont(CS_FONT_PATH, 10, "")
        else
            MB_PullButton:SetNormalFontObject(GameFontHighlightSmall)
        end
    end

    if MB_SyncButton and MB_SyncButton:GetFontString() then
        if MB_Lang == "cs" then
            MB_SyncButton:GetFontString():SetFont(CS_FONT_PATH, 10, "")
        else
            MB_SyncButton:SetNormalFontObject(GameFontHighlightSmall)
        end
    end

    -- toggle tlačítko (+/-)
    if MB_ToggleButton and MB_ToggleButton:GetFontString() then
        if MB_Lang == "cs" then
            MB_ToggleButton:GetFontString():SetFont(CS_FONT_PATH, 12, "OUTLINE")
        else
            MB_ToggleButton:GetFontString():SetFont(GameFontHighlight:GetFont(), 12, "OUTLINE")
        end
    end
end

-------------------------------------------------
-- Přepínání textů (title, tlačítka) podle MB_Lang
-------------------------------------------------
local function ApplyLocalizationTexts()
    if MB_InfoFrame and MB_InfoFrame.title then
        MB_InfoFrame.title:SetText(L("Bankéř – materiály", "Banker materials"))
    end

    if MB_PullButton then
        MB_PullButton:SetText(L("Vybrat", "Withdraw"))
    end

    if MB_SyncButton then
        MB_SyncButton:SetText(L("Sync", "Sync"))
    end
end

-------------------------------------------------
-- Získání reagentů pro aktuální recept
-------------------------------------------------
local function GetCurrentReagents()
    local reagents = {}

    if MB_CurrentMode == "trade" and TradeSkillFrame and TradeSkillFrame:IsShown() then
        local idx = GetTradeSkillSelectionIndex()
        if not idx or idx == 0 then
            return reagents
        end

        local num = GetTradeSkillNumReagents(idx) or 0
        for i = 1, num do
            local reagentName, _, reagentCount = GetTradeSkillReagentInfo(idx, i)
            local itemLink = GetTradeSkillReagentItemLink(idx, i)
            if itemLink and reagentCount and reagentCount > 0 then
                local itemId = tonumber(string.match(itemLink, "item:(%d+)"))
                if itemId then
                    table.insert(reagents, {
                        id     = itemId,
                        name   = reagentName or ("Item " .. itemId),
                        link   = itemLink,
                        needed = reagentCount,
                    })
                end
            end
        end

    elseif MB_CurrentMode == "craft" and CraftFrame and CraftFrame:IsShown() then
        local idx = GetCraftSelectionIndex()
        if not idx or idx == 0 then
            return reagents
        end

        local num = GetCraftNumReagents(idx) or 0
        for i = 1, num do
            local reagentName, _, reagentCount = GetCraftReagentInfo(idx, i)
            local itemLink = GetCraftReagentItemLink(idx, i)
            if itemLink and reagentCount and reagentCount > 0 then
                local itemId = tonumber(string.match(itemLink, "item:(%d+)"))
                if itemId then
                    table.insert(reagents, {
                        id     = itemId,
                        name   = reagentName or ("Item " .. itemId),
                        link   = itemLink,
                        needed = reagentCount,
                    })
                end
            end
        end
    end

    return reagents
end

-------------------------------------------------
-- Parsování SYNC zpráv z modulu (.mb sync)
-------------------------------------------------
local function HandleSyncSystemMessage(msg)
    local lang = msg:match("SYNC_LANG=(%a+)")
    if lang then
        if lang == "en" then
            MB_Lang = "en"
        else
            MB_Lang = "cs"
        end

        if MaterialBankCache then
            MaterialBankCache._lang = MB_Lang
        end

        ApplyLocalizationTexts()
        ApplyLocalizationFonts()
        return
    end

    if msg:find("SYNC_BEGIN", 1, true) then
        syncTemp = {}
		syncMoneyTemp = nil
        return
    end

    if msg:find("SYNC_END", 1, true) then
        if syncTemp and cache then
            for k in pairs(cache) do
                cache[k] = nil
            end
            for itemId, data in pairs(syncTemp) do
			cache[itemId] = {
                total    = data.total,
                category = data.category,
                name     = data.name,
            }

            end
			
			if syncMoneyTemp ~= nil then
				cache._money = syncMoneyTemp
			
				MaterialBankCache = MaterialBankCache or {}
				MaterialBankCache._money = MaterialBankCache._money or {}
			
				local faction = UnitFactionGroup("player") or "Neutral"
				MaterialBankCache._money[faction] = MaterialBankCache._money[faction] or { copper = 0 }
				MaterialBankCache._money[faction].copper = syncMoneyTemp
			end

            cache._hasSync = true
        end

        syncTemp = nil
        syncMoneyTemp = nil

        local text = L(
            "|cff00ff00[Bankéř]|r Synchronizace s bankéřem dokončena.",
            "|cff00ff00[Banker]|r Sync complete."
        )
        DEFAULT_CHAT_FRAME:AddMessage(text)

        ApplyLocalizationTexts()
        ApplyLocalizationFonts()
        return
    end

	-- MONEY SYNC
	local balStr = msg:match("SYNC%s+money=(%d+)")
	if balStr then
		syncMoneyTemp = tonumber(balStr) or 0
		return
	end

	if not syncTemp then
		return
	end
	
	local item, cat, total, name = msg:match('SYNC item=(%d+)%s+cat=(%d+)%s+total=(%d+)%s+name="(.-)"')
	if item and cat and total then
		item  = tonumber(item)
		cat   = tonumber(cat)
		total = tonumber(total)
	
		syncTemp[item] = {
			total    = total,
			category = cat,
			name     = name,
		}
		return
	end
	
	local item2, cat2, total2 = msg:match("SYNC item=(%d+)%s+cat=(%d+)%s+total=(%d+)")
	if item2 and cat2 and total2 then
		item2  = tonumber(item2)
		cat2   = tonumber(cat2)
		total2 = tonumber(total2)
	
		syncTemp[item2] = {
			total    = total2,
			category = cat2,
		}
	end
end

-------------------------------------------------
-- Skrytá meta zpráva z modulu
-- Formát: MB_UPDATE item=<id> cat=<catId>
-------------------------------------------------
local function HandleBankMetaMessage(msg)
    if not msg or msg == "" then
        return false
    end

    if not msg:find("MB_UPDATE", 1, true) then
        return false
    end

    local itemStr, catStr = msg:match("MB_UPDATE%s+item=(%d+)%s+cat=(%d+)")
    if not itemStr or not catStr then
        return false
    end

    local itemId = tonumber(itemStr)
    local catId  = tonumber(catStr)
    if not itemId or not catId then
        return false
    end

    if cache then
        cache[itemId] = cache[itemId] or { total = 0, category = 0 }
        cache[itemId].category = catId
    end

    if type(MBM_RequestHardReload) == "function" then
        MBM_RequestHardReload()
    end

    return true
end

-------------------------------------------------
-- Úprava cache podle hlášek o vkladu/výběru/pullu
-------------------------------------------------
local function AdjustCache(itemId, delta)
    if not cache or not itemId or not delta or delta == 0 then
        return
    end

    cache[itemId] = cache[itemId] or { total = 0, category = 0 }
    local newTotal = (cache[itemId].total or 0) + delta
    if newTotal < 0 then
        newTotal = 0
    end
    cache[itemId].total = newTotal
end

local function HandleBankDeltaMessage(msg)
    local itemIdStr = msg:match("item:(%d+)")
    if not itemIdStr then
        return
    end

    local itemId = tonumber(itemIdStr)
    if not itemId then
        return
    end

    local countStr

    if msg:find("Uloženo", 1, true) or msg:find("Deposited", 1, true) then
        countStr = msg:match("Uloženo%s+(%d+)x") or msg:match("Deposited%s+(%d+)x")
        if countStr then
            AdjustCache(itemId, tonumber(countStr))
        end
        return
    end

    if msg:find("Vybráno", 1, true) or msg:find("Withdrawn", 1, true) then
        countStr = msg:match("Vybráno%s+(%d+)x") or msg:match("Withdrawn%s+(%d+)x")
        if countStr then
            AdjustCache(itemId, -tonumber(countStr))
        end
        return
    end

    if msg:find("Vytaženo", 1, true) or msg:find("Pulled", 1, true) then
        countStr = msg:match("Vytaženo%s+(%d+)x") or msg:match("Pulled%s+(%d+)x")
        if countStr then
            AdjustCache(itemId, -tonumber(countStr))
        end
        return
    end
end

-------------------------------------------------
-- Tooltip: pomocné funkce pro Material Bank řádek
-------------------------------------------------
local function MB_GetBankCount(itemId)
    if not cache or not itemId then
        return 0
    end
    local e = cache[itemId]
    if not e or not e.total then
        return 0
    end
    return e.total
end

local function MB_AddTooltipBankLine(tooltip, itemLink)
    if not tooltip or not itemLink then
        return
    end

    local itemId = tonumber(string.match(itemLink, "item:(%d+)"))
    if not itemId then
        return
    end

    local total = MB_GetBankCount(itemId)
    if not total or total <= 0 then
        return
    end

    local tName = tooltip:GetName()
    if tName then
        for i = 1, tooltip:NumLines() do
            local fs = _G[tName .. "TextLeft" .. i]
            if fs then
                local txt = fs:GetText()
                if txt and (txt:find("Material Bank") or txt:find("Material banka")) then
                    return
                end
            end
        end
    end

    local label = L("Material banka: ", "Material Bank: ")
    tooltip:AddLine(label .. total, 0.2, 0.8, 0.2)
    tooltip:Show()
end

local function MB_HookTooltip(tip)
    if not tip or tip.MB_Hooked_MBTooltip then
        return
    end

    tip:HookScript("OnTooltipSetItem", function(self)
        local _, link = self:GetItem()
        if link then
            MB_AddTooltipBankLine(self, link)
        end
    end)

    tip.MB_Hooked_MBTooltip = true
end

-------------------------------------------------
-- Info okno vedle crafting okna
-------------------------------------------------
local function EnsureInfoFrame(parent)
    if MB_InfoFrame then
        MB_InfoFrame:SetParent(parent)

        MB_InfoFrame:SetSize(MB_EXPANDED_W, MB_EXPANDED_H)
        MB_InfoFrame:SetBackdrop(MB_BackdropDef)
        MB_InfoFrame:SetBackdropColor(0, 0, 0, 0.8)
        if MB_InfoFrame.title then MB_InfoFrame.title:Show() end

        MB_SetExpandedAnchor(parent)
        return
    end


    MB_InfoFrame = CreateFrame("Frame", "MB_InfoFrame", parent)
    MB_InfoFrame:SetSize(MB_EXPANDED_W, MB_EXPANDED_H)
    MB_SetExpandedAnchor(parent)

    MB_InfoFrame:SetBackdrop(MB_BackdropDef)
    MB_InfoFrame:SetBackdropColor(0, 0, 0, 0.8)

    local title = MB_InfoFrame:CreateFontString(nil, "OVERLAY", "GameFontHighlight")
    title:SetPoint("TOP", MB_InfoFrame, "TOP", 0, -6)
    title:SetText(L("Bankéř – materiály", "Banker materials"))
    MB_InfoFrame.title = title

    MB_ToggleButton = CreateFlatButton("MB_ToggleButton", MB_InfoFrame, "-")
    MB_ToggleButton:SetSize(MB_TOGGLE_W, MB_TOGGLE_H)
    MB_ToggleButton:ClearAllPoints()
    MB_ToggleButton:SetPoint("TOPLEFT", MB_InfoFrame, "TOPLEFT", MB_TOGGLE_PAD_X, MB_TOGGLE_PAD_Y)
    MB_ToggleButton:SetFrameStrata(MB_InfoFrame:GetFrameStrata())
    MB_ToggleButton:SetFrameLevel(MB_InfoFrame:GetFrameLevel() + 2)
    MB_ToggleButton:Show()

    MB_ToggleButton:SetScript("OnClick", function()
        MB_TableHidden = not MB_TableHidden

        MaterialBankCache = MaterialBankCache or {}
        MaterialBankCache._tableHidden = (MB_TableHidden == true)

        MB_ApplyTableVisibility()

        if not MB_TableHidden and UpdateInfoPanel then
            UpdateInfoPanel()
        end
    end)

    MB_UpdateToggleVisual()

    MB_InfoLines = {}
    for i = 1, 6 do
        local line = CreateFrame("Frame", "MB_InfoLine"..i, MB_InfoFrame)
        line:SetSize(145, 50)

        local col = (i <= 3) and 1 or 2
        local row = ((i - 1) % 3) + 1

        local x = (col == 1) and 8 or 175
        local y = -30 - (row - 1) * 50

        line:SetPoint("TOPLEFT", MB_InfoFrame, "TOPLEFT", x, y)

        local nameBtn = CreateFrame("Button", nil, line)
        nameBtn:SetPoint("TOPLEFT", line, "TOPLEFT", 0, 0)
        nameBtn:SetSize(118, 12)

        local nameFS = nameBtn:CreateFontString(nil, "OVERLAY", "GameFontHighlightSmall")
        nameFS:SetPoint("LEFT", nameBtn, "LEFT", 0, 0)
        nameFS:SetJustifyH("LEFT")
        nameFS:SetText("")

        local infoFS = line:CreateFontString(nil, "OVERLAY", "GameFontHighlightSmall")
        infoFS:SetPoint("TOPLEFT", line, "TOPLEFT", 0, -12)
        infoFS:SetJustifyH("LEFT")
        infoFS:SetText("")

        local iconBtn = CreateFrame("Button", nil, line)
        iconBtn:SetSize(26, 26)
        iconBtn:SetPoint("TOPLEFT", line, "TOPLEFT", 80, -15)

        local icon = iconBtn:CreateTexture(nil, "ARTWORK")
        icon:SetAllPoints(iconBtn)
        icon:SetTexture("Interface\\Icons\\INV_Misc_QuestionMark")
        iconBtn:Hide()

        line.nameBtn  = nameBtn
        line.nameFS   = nameFS
        line.infoFS   = infoFS
        line.iconBtn  = iconBtn
        line.icon     = icon
        line.itemLink = nil

        nameBtn:SetScript("OnEnter", function(self)
            local p = self:GetParent()
            if p and p.itemLink then
                GameTooltip:SetOwner(self, "ANCHOR_CURSOR")
                GameTooltip:SetHyperlink(p.itemLink)
                GameTooltip:Show()
            end
        end)
        nameBtn:SetScript("OnLeave", function() GameTooltip:Hide() end)
        nameBtn:SetScript("OnClick", function(self)
            local p = self:GetParent()
            if p and p.itemLink then
                HandleModifiedItemClick(p.itemLink)
            end
        end)

        iconBtn:SetScript("OnEnter", function(self)
            local p = self:GetParent()
            if p and p.itemLink then
                GameTooltip:SetOwner(self, "ANCHOR_CURSOR")
                GameTooltip:SetHyperlink(p.itemLink)
                GameTooltip:Show()
            end
        end)
        iconBtn:SetScript("OnLeave", function() GameTooltip:Hide() end)
        iconBtn:SetScript("OnClick", function(self)
            local p = self:GetParent()
            if p and p.itemLink then
                HandleModifiedItemClick(p.itemLink)
            end
        end)

        MB_InfoLines[i] = line
    end

    ApplyLocalizationTexts()
    ApplyLocalizationFonts()
    MB_ApplyTableVisibility()
end

-------------------------------------------------
-- Pomocný helper na vizuální enable/disable Vybrat
-------------------------------------------------
local function SetPullButtonState(enabled)
    if not MB_PullButton then
        return
    end

    local fs = MB_PullButton:GetFontString()

    if enabled then
        MB_PullButton:Enable()
        MB_PullButton.bg:SetVertexColor(0.1, 0.45, 0.9, 0.9)
        if fs then fs:SetTextColor(1, 1, 1) end
    else
        MB_PullButton:Disable()
        MB_PullButton.bg:SetVertexColor(0.25, 0.25, 0.25, 0.9)
        if fs then fs:SetTextColor(0.5, 0.5, 0.5) end
    end
end

-------------------------------------------------
-- Barvení čísel podle dostupnosti
-------------------------------------------------
local function MB_ColorCount(count, totalAvailable, totalNeed)
    local n = tonumber(count) or 0
    if n <= 0 then
        return "|cffff3333" .. n .. "|r"
    end

    local avail = tonumber(totalAvailable) or 0
    local need  = tonumber(totalNeed) or 0

    if need > 0 and avail < need then
        return "|cffffff00" .. n .. "|r"
    end

    return "|cff00ff00" .. n .. "|r"
end

-------------------------------------------------
-- Nastavení klikací plochy názvu na šířku textu
-------------------------------------------------
local function MB_FitNameButton(line)
    if not line or not line.nameBtn or not line.nameFS then
        return
    end

    local txt = line.nameFS:GetText()
    if not txt or txt == "" then
        line.nameBtn:SetWidth(1)
        return
    end

    local w = line.nameFS:GetStringWidth() or 0
    w = math.ceil(w + 4)

    local maxW = line:GetWidth() or 140
    if w > maxW then w = maxW end
    if w < 1 then w = 1 end

    line.nameBtn:SetWidth(w)
end

-------------------------------------------------
-- Počítadlo craftů: rám, text, šipky
-------------------------------------------------
local function EnsureCountControls()
    if MB_CountFrame or not MB_InfoFrame then
        return
    end

    MB_CountFrame = CreateFrame("Frame", "MB_CountFrame", MB_InfoFrame)
    MB_CountFrame:SetSize(80, 18)

    MB_CountDown = CreateFrame("Button", "MB_CountDown", MB_CountFrame, "UIPanelButtonTemplate")
    MB_CountDown:SetSize(18, 18)
    MB_CountDown:SetPoint("LEFT", MB_CountFrame, "LEFT", 0, 0)
    MB_CountDown:SetText("-")

    MB_CountUp = CreateFrame("Button", "MB_CountUp", MB_CountFrame, "UIPanelButtonTemplate")
    MB_CountUp:SetSize(18, 18)
    MB_CountUp:SetPoint("RIGHT", MB_CountFrame, "RIGHT", 0, 0)
    MB_CountUp:SetText("+")

    MB_CountText = MB_CountFrame:CreateFontString(nil, "OVERLAY", "GameFontHighlightSmall")
    MB_CountText:SetPoint("CENTER", MB_CountFrame, "CENTER", 0, 0)
    MB_CountText:SetText("x" .. MB_CraftCount)

    MB_CountDown:SetScript("OnClick", function()
        if MB_CraftCount > 1 then
            MB_CraftCount = MB_CraftCount - 1
            UpdateInfoPanel()
        end
    end)

    MB_CountUp:SetScript("OnClick", function()
        if MB_CraftMax > 0 and MB_CraftCount < MB_CraftMax then
            MB_CraftCount = MB_CraftCount + 1
            UpdateInfoPanel()
        end
    end)
end

-------------------------------------------------
-- Tlačítka Withdraw a Sync
-------------------------------------------------
local function EnsureButtons()
    if MB_PullButton and MB_SyncButton then
        return
    end

    if not MB_PullButton then
        local btn = CreateFlatButton("MB_PullButton", UIParent, "Withdraw")

        btn:SetScript("OnClick", function()
            local reagents = GetCurrentReagents()
            if not reagents or #reagents == 0 then
                UIErrorsFrame:AddMessage("No reagents for this recipe.", 1, 0.2, 0.2)
                return
            end

            if MB_CraftMax <= 0 then
                UIErrorsFrame:AddMessage(L(
                    "Nedostatek materiálů u bankéře.",
                    "Not enough materials at banker."
                ), 1, 0.2, 0.2)
                return
            end

            local parts = {}
            local crafts = MB_CraftCount or 1
            if crafts < 1 then crafts = 1 end

            for _, r in ipairs(reagents) do
                local perNeed = r.needed or 0
                if perNeed > 0 then
                    local totalNeed = perNeed * crafts
                    local bagCount  = GetItemCount(r.id) or 0
                    local missing   = totalNeed - bagCount
                    if missing < 0 then missing = 0 end
                    if missing > 0 then
                        table.insert(parts, r.id .. ":" .. missing)
                    end
                end
            end

			if #parts == 0 then
				for _, r in ipairs(reagents) do
					local perNeed = r.needed or 0
					if perNeed > 0 then
						local totalNeed = perNeed * crafts
						if totalNeed > 0 then
							table.insert(parts, r.id .. ":" .. totalNeed)
						end
					end
				end
			end
			
			if #parts == 0 then
				UIErrorsFrame:AddMessage(L(
					"Není co vybrat.",
					"Nothing to withdraw."
				), 1, 0.8, 0.2)
				return
			end

            SendChatMessage(".mb pull " .. table.concat(parts, " "), "SAY")
        end)

        MB_PullButton = btn
    end

    if not MB_SyncButton then
        local btn = CreateFlatButton("MB_SyncButton", UIParent, "Sync")
        btn:SetScript("OnClick", function()
            SendChatMessage(".mb sync", "SAY")
        end)
        MB_SyncButton = btn
    end

    ApplyLocalizationTexts()
    ApplyLocalizationFonts()
end

-------------------------------------------------
-- Umístění do Tradeskill / Craft + do rámečku
-------------------------------------------------
local function AttachButtonsToInfoFrame()
    if not MB_InfoFrame or not MB_PullButton or not MB_SyncButton then
        return
    end

    MB_SyncButton:SetParent(MB_InfoFrame)
    MB_SyncButton:ClearAllPoints()
    MB_SyncButton:SetPoint("TOPRIGHT", MB_InfoFrame, "TOPRIGHT", -12, -6)
    MB_SyncButton:SetFrameStrata(MB_InfoFrame:GetFrameStrata())
    MB_SyncButton:SetFrameLevel(MB_InfoFrame:GetFrameLevel() + 1)

    MB_PullButton:SetParent(MB_InfoFrame)
    MB_PullButton:ClearAllPoints()
    MB_PullButton:SetPoint("BOTTOM", MB_InfoFrame, "BOTTOM", -20, 10)
    MB_PullButton:SetFrameStrata(MB_InfoFrame:GetFrameStrata())
    MB_PullButton:SetFrameLevel(MB_InfoFrame:GetFrameLevel() + 1)

    EnsureCountControls()
    if MB_CountFrame then
        MB_CountFrame:SetParent(MB_InfoFrame)
        MB_CountFrame:ClearAllPoints()
        MB_CountFrame:SetPoint("LEFT", MB_PullButton, "RIGHT", 8, 0)
    end

    MB_ApplyTableVisibility()

    ApplyLocalizationTexts()
    ApplyLocalizationFonts()
end

local function AttachToTradeSkill()
    EnsureButtons()
    MB_CurrentMode = "trade"

    EnsureInfoFrame(TradeSkillFrame)
    MB_InfoFrame:Show()
    AttachButtonsToInfoFrame()
    UpdateInfoPanel()

    if not MB_HookedTrade then
        if type(TradeSkillFrame_SetSelection) == "function" then
            hooksecurefunc("TradeSkillFrame_SetSelection", function()
                MB_CurrentMode = "trade"
                UpdateInfoPanel()
            end)
        end
        MB_HookedTrade = true
    end
end

local function AttachToCraft()
    EnsureButtons()
    MB_CurrentMode = "craft"

    EnsureInfoFrame(CraftFrame)
    MB_InfoFrame:Show()
    AttachButtonsToInfoFrame()
    UpdateInfoPanel()

    if not MB_HookedCraft then
        if type(CraftFrame_SetSelection) == "function" then
            hooksecurefunc("CraftFrame_SetSelection", function()
                MB_CurrentMode = "craft"
                UpdateInfoPanel()
            end)
        end
        MB_HookedCraft = true
    end
end

-------------------------------------------------
-- UpdateInfoPanel (dopředně deklarované)
-------------------------------------------------
UpdateInfoPanel = function()
    if not MB_InfoFrame or not MB_InfoFrame:IsShown() then
        return
    end

    if MB_TableHidden then
        MB_ApplyTableVisibility()
        return
    end

    local hasSync = (cache and cache._hasSync == true)

    -- vyčistit řádky
    for i = 1, #MB_InfoLines do
        local line = MB_InfoLines[i]
        if line then
            if line.nameFS then line.nameFS:SetText("") end
            if line.nameBtn then line.nameBtn:SetWidth(1) end
            if line.infoFS then line.infoFS:SetText("") end
            if line.iconBtn then line.iconBtn:Hide() end
            if line.icon then line.icon:SetTexture(nil) end
            line.itemLink = nil
        end
    end

    if not hasSync then
        if MB_PullButton then MB_PullButton:Hide() end
        if MB_CountFrame then MB_CountFrame:Hide() end
        SetPullButtonState(false)

        MB_CraftMax = 0
        MB_CraftCount = 1
        if MB_CountText then
            MB_CountText:SetText("x" .. MB_CraftCount)
        end

        if MB_InfoLines[1] and MB_InfoLines[1].infoFS then
            MB_InfoLines[1].infoFS:SetText(
                "Pro první použití je potřeba provést |cff00ff00Sync|r.\n" ..
                "Jazyk tabulky se nastaví v okamžiku, kdy provedeš Sync.\n" ..
                "Sync pak obvykle není nutné opakovat, pokud není problém.\n\n" ..
                "For first use you need to run |cff00ff00Sync|r.\n" ..
                "Table language will be set when you run Sync.\n" ..
                "You usually don't need to sync again unless there's an issue."
            )
        end
        return
    end

    if MB_SyncButton and not MB_SyncButton:IsShown() then
        MB_SyncButton:Show()
    end

    local reagents = GetCurrentReagents()

    if not reagents or #reagents == 0 then
        if MB_InfoLines[1] and MB_InfoLines[1].infoFS then
            MB_InfoLines[1].infoFS:SetText(L(
                "Pro tento recept nejsou žádné reagenty.",
                "No reagents for this recipe."
            ))
        end
        MB_CraftMax = 0
        MB_CraftCount = 1
        if MB_CountText then
            MB_CountText:SetText("x" .. MB_CraftCount)
        end
        SetPullButtonState(false)
        if MB_PullButton then MB_PullButton:Hide() end
        if MB_CountFrame then MB_CountFrame:Hide() end
        return
    end

    local maxCrafts
    for _, r in ipairs(reagents) do
        local bankCount = 0
        if cache and cache[r.id] and cache[r.id].total then
            bankCount = cache[r.id].total
        end

        local bagCount = GetItemCount(r.id) or 0
        if r.needed and r.needed > 0 then
            local totalAvailable = bankCount + bagCount
            local craftsForThis = math.floor(totalAvailable / r.needed)
            if not maxCrafts or craftsForThis < maxCrafts then
                maxCrafts = craftsForThis
            end
        end
    end

    MB_CraftMax = maxCrafts or 0
    if MB_CraftMax < 0 then MB_CraftMax = 0 end

    if MB_CraftMax == 0 then
        MB_CraftCount = 1
    else
        if MB_CraftCount > MB_CraftMax then
            MB_CraftCount = MB_CraftMax
        elseif MB_CraftCount < 1 then
            MB_CraftCount = 1
        end
    end

    if MB_CountText then
        MB_CountText:SetText("x" .. MB_CraftCount)
    end

    if MB_CraftMax <= 0 then
        SetPullButtonState(false)
        if MB_PullButton then MB_PullButton:Hide() end
        if MB_CountFrame then MB_CountFrame:Hide() end
    else
        SetPullButtonState(true)
        if MB_PullButton then MB_PullButton:Show() end
        if MB_CountFrame then MB_CountFrame:Show() end
    end

    for i, r in ipairs(reagents) do
        if i > #MB_InfoLines then break end

        local line = MB_InfoLines[i]
        if line then
            local bankCount = 0
            if cache and cache[r.id] and cache[r.id].total then
                bankCount = cache[r.id].total
            end

            local bagCount = GetItemCount(r.id) or 0

            local perNeed    = r.needed or 0
            local totalNeed  = perNeed * (MB_CraftCount or 1)
            local totalAvail = (bankCount or 0) + (bagCount or 0)

            local name = r.link or r.name or ("Item " .. r.id)

            if line.nameFS then
                line.nameFS:SetText(name)
            end
            MB_FitNameButton(line)

            if line.icon then
                local tex = GetItemIcon(r.id)
                if not tex then
                    local _, _, _, _, _, _, _, _, _, iconFile = GetItemInfo(r.id)
                    tex = iconFile
                end
                line.icon:SetTexture(tex or "Interface\\Icons\\INV_Misc_QuestionMark")
                if line.iconBtn then line.iconBtn:Show() end
            end

            local bagColored  = MB_ColorCount(bagCount or 0, totalAvail, totalNeed)
            local bankColored = MB_ColorCount(bankCount or 0, totalAvail, totalNeed)

            local infoText = L(
                string.format("  Potřeba: %d\n  Inventář: %s\n  Bankéř: %s", totalNeed, bagColored, bankColored),
                string.format("  Needed: %d\n  Inventory: %s\n  Banker: %s", totalNeed, bagColored, bankColored)
            )

            if line.infoFS then
                line.infoFS:SetText(infoText)
            end

            line.itemLink = r.link
        end
    end
end

-------------------------------------------------
-- Hlavní event handler
-------------------------------------------------
frame:SetScript("OnEvent", function(self, event, ...)
    if event == "ADDON_LOADED" then
        local name = ...
        if name ~= addonName then
            return
        end

        MaterialBankCache = MaterialBankCache or {}

        local key = GetCharKey()
        MaterialBankCache[key] = MaterialBankCache[key] or {}
        cache = MaterialBankCache[key]
        cache._hasSync = (cache._hasSync == true)

        MB_TableHidden = (MaterialBankCache._tableHidden == true)

        if MaterialBankCache._lang == "cs" or MaterialBankCache._lang == "en" then
			MB_Lang = MaterialBankCache._lang
		else
			MB_Lang = "en"
		end

        ChatFrame_AddMessageEventFilter("CHAT_MSG_SYSTEM", MaterialBank_SystemFilter)

        MB_HookTooltip(GameTooltip)
        if ItemRefTooltip then
            MB_HookTooltip(ItemRefTooltip)
        end

        ApplyLocalizationTexts()
        ApplyLocalizationFonts()

    elseif event == "TRADE_SKILL_SHOW" then
        AttachToTradeSkill()

    elseif event == "CRAFT_SHOW" then
        AttachToCraft()

    elseif event == "TRADE_SKILL_CLOSE" or event == "CRAFT_CLOSE" then
        if MB_PullButton then MB_PullButton:Hide() end
        if MB_SyncButton then MB_SyncButton:Hide() end
        if MB_InfoFrame then MB_InfoFrame:Hide() end
        if MB_CountFrame then MB_CountFrame:Hide() end

    elseif event == "CHAT_MSG_SYSTEM" then
        local msg = ...
		
		if HandleBankMetaMessage(msg) then
			UpdateInfoPanel()
			return
		end
		
        HandleSyncSystemMessage(msg)
        HandleBankDeltaMessage(msg)
        UpdateInfoPanel()
    end
end)
